/////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2005-2007 Association Homecinema Francophone.  All rights reserved.
/////////////////////////////////////////////////////////////////////////////
//
//  This file is subject to the terms of the GNU General Public License as
//  published by the Free Software Foundation.  A copy of this license is
//  included with this software distribution in the file COPYING.htm. If you
//  do not have a copy, you may obtain a copy by writing to the Free
//  Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  This software is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details
//
/////////////////////////////////////////////////////////////////////////////
//  Author(s):
//	Georges GALLERAND
/////////////////////////////////////////////////////////////////////////////

// CHCFRDX2.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "stdio.h"
#include "stdlib.h"

// Include for device interface (this device interface is outside GNU GPL license)
#include "devlib\CHCFRDI2.h"

#define SPECTRUM_BANDS					36

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	BOOL	bOk = FALSE;
	BOOL	bContinue = TRUE;
	BOOL	b;
	UINT	u;
	DWORD	dw;
	char	szBuf [ 4096 ];
	BOOL	bSpectrumOk = FALSE;
	double	x, y, z;
	double	Spectrum[SPECTRUM_BANDS];

	dw = GetTickCount ();
	
	if ( lpCmdLine [0] != 0 )
	{
		// Parameter is GetTickCount taken immediately before running this program
		u = atoi ( lpCmdLine );
		if ( dw >= u && dw < u + 10000 )
			bOk = TRUE;
	}

	if ( bOk )
	{
		sprintf ( szBuf, "\\\\.\\pipe\\CHCFRDX2_TO_COLORHCFR_PIPE_%08X", u );
		HANDLE hPipe = CreateNamedPipe ( szBuf, PIPE_ACCESS_DUPLEX, PIPE_TYPE_BYTE | PIPE_READMODE_BYTE | PIPE_WAIT, 1, 0, 0, 10000, NULL );

		if ( hPipe != INVALID_HANDLE_VALUE )
		{
			while ( bContinue )
			{
				if ( ReadFile ( hPipe, szBuf, 3, & dw, NULL ) )
				{
					switch ( szBuf [ 0 ] )
					{
						case 'I':	// Init (followed by InitDevice2 parameter: "I0b", "I1b", "I2b", "I3b" with b is "0" or "1" )
							 u = (UINT) (unsigned char) ( szBuf [ 1 ] - '0' );
							 b = ( szBuf [ 2 ] == '1' );
							 bOk = InitDevice2 ( u, b, szBuf + 2 );
							 
							 // Answer: first character is return code, then ":", then error message
							 szBuf [ 0 ] = ( (char)bOk + '0' );
							 szBuf [ 1 ] = ':';
							 WriteFile ( hPipe, szBuf, strlen(szBuf)+1, & dw, NULL );
							 break;

						case 'R':	// Release
							 ReleaseDevice2 ();
							 
							 // Answer: "1" (means OK)
							 strcpy ( szBuf, "1" );
							 WriteFile ( hPipe, szBuf, strlen(szBuf)+1, & dw, NULL );
							 break;

						case 'C':	// Calibrate
							 bOk = CalibrateDevice2 ( szBuf + 2 );
							 
							 // Answer: first character is return code (true/false -> 1/0), then ":", then error message
							 szBuf [ 0 ] = bOk ? '1' : '0';
							 szBuf [ 1 ] = ':';
							 WriteFile ( hPipe, szBuf, strlen(szBuf)+1, & dw, NULL );
							 break;

						case 'N':	// Need calibration ?
							 bOk = Device2NeedCalibration ();

							 // Answer: return code (true/false -> 1/0)
							 szBuf [ 0 ] = bOk ? '1' : '0';
							 szBuf [ 1 ] = '\0';
							 WriteFile ( hPipe, szBuf, strlen(szBuf)+1, & dw, NULL );
							 break;

						case 'M':	// Measure
							 x = y = z = 1.0;
							 bOk = GetValuesDevice2 ( & x, & y, & z, Spectrum, & bSpectrumOk );

							 // Answer: first character is return code (true/false -> 1/0), then ":", then list of values
							 szBuf [ 0 ] = bOk ? '1' : '0';
							 szBuf [ 1 ] = ':';
							 sprintf ( szBuf + 2, "%9.5f,%9.5f,%9.5f,%d|", x, y, z, bSpectrumOk );
							 if ( bSpectrumOk )
							 {
								for ( int i = 0; i < SPECTRUM_BANDS ; i++ )
									sprintf ( strchr ( szBuf, 0), "%9.5f,", Spectrum [ i ] );
							 }

							 WriteFile ( hPipe, szBuf, strlen(szBuf)+1, & dw, NULL );
							 break;

						case 'X':	// Exit
							 bContinue = FALSE;
							 break;
					}
				}
				else
				{
					Sleep ( 0 );
				}
			}

			CloseHandle ( hPipe );
			return 0;
		}
	}

	return 1;
}

